/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.base.VWDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Properties;

public class VWTaskServiceProperties {
    public static final String PREVIOUS_REGISTRY_PORT = "TaskServiceManager.PreviousRegistryPort";
    public static final String LAST_ACTION = "TaskServiceManager.LastAction";
    public static final String LAST_ACTION_TIMESTAMP = "TaskServiceManager.LastActionTimeStamp";
    public static final String OUTOFSEQUENCE_LOCK = "TaskServiceManager.OutOfSequenceLock";
    private static final HashMap m_instanceMap = new HashMap();
    private long m_lastModified = 0L;
    private Properties m_properties = null;
    private Properties m_defaultProperties = null;
    private String m_propertiesPath = null;

    protected static VWTaskServiceProperties getInstance() {
        return VWTaskServiceProperties.getInstance(System.getProperty("TaskManager.Properties"));
    }

    public static VWTaskServiceProperties getInstance(String taskmanPropsPath) {
        if (m_instanceMap.containsKey(taskmanPropsPath)) {
            return (VWTaskServiceProperties)m_instanceMap.get(taskmanPropsPath);
        }
        VWTaskServiceProperties sp = new VWTaskServiceProperties(taskmanPropsPath);
        m_instanceMap.put(taskmanPropsPath, sp);
        return sp;
    }

    private VWTaskServiceProperties(String taskmanPropsPath) {
        this.m_propertiesPath = VWTaskUtil.removeTrailingSlash(new File(taskmanPropsPath).getParent()) + File.separator + "taskmanservice.properties";
        this.m_defaultProperties = new Properties();
        this.m_defaultProperties.setProperty(PREVIOUS_REGISTRY_PORT, "32771");
        this.m_defaultProperties.setProperty(LAST_ACTION, "stop");
        this.readProperties();
    }

    public synchronized String getProperty(String key) {
        this.readProperties();
        return this.m_properties.getProperty(key);
    }

    public synchronized void setProperty(String key, String value) {
        this.readProperties();
        this.m_properties.setProperty(key, value);
        this.writeProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties() {
        File propertiesFile;
        if (this.m_properties == null) {
            this.m_properties = this.m_defaultProperties;
        }
        if (!(propertiesFile = new File(this.m_propertiesPath)).exists()) {
            return;
        }
        long modifiedTime = propertiesFile.lastModified();
        if (modifiedTime <= this.m_lastModified) {
            return;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.m_propertiesPath);
            this.m_properties = new Properties(this.m_defaultProperties);
            this.m_properties.load(is);
            this.m_lastModified = modifiedTime;
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties() {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.m_propertiesPath);
            this.m_properties.store(os, null);
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

